package org.msh.tb.bd.tbforms.query.tb10;

import org.msh.tb.bd.Quarter;
import org.msh.tb.bd.tbforms.query.TbFormQuery;
import org.msh.tb.entities.AdministrativeUnit;
import org.msh.tb.entities.Tbunit;
import org.msh.tb.entities.Workspace;
import org.msh.tb.entities.enums.TbFormField;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import java.util.List;

/**
 * Created by Mauricio on 11/03/2017.
 * Query database for Tb Form 10 Block 2 Result
 */
public class TBForm10Block2Query implements TbFormQuery {

    @Override
    public List<Object[]> queryDB(Tbunit tbunit, AdministrativeUnit adminUnit, Workspace workspace, Quarter selectedQuarter, EntityManager em) {
        Query query;

        String queryStr = "select c.patientRefToFv.customId, c.patientRefToFv.name.name1, count(*) "
                + " from TbCaseBD c join c.patient p "
                + " where c.registrationDate between :iniDate and :endDate %restriction% "
                + " and (c.patientType in (0,48) or ( c.patientType = 44 and c.previouslyTreatedType in (1,45,46,47) ) )"
                + " and c.classification = 0 and c.diagnosisType = 1 and c.age is not null and p.gender is not null "
                + " group by c.patientRefToFv ";

        if (tbunit != null) {
            // add tbunit restriction
            queryStr = queryStr.replace("%restriction%", "and c.notificationUnit.id = :unitId");
            query = em.createQuery(queryStr);
            query.setParameter("unitId", tbunit.getId());
        } else if (adminUnit != null) {
            // add adminunit restriction
            queryStr = queryStr.replace("%restriction%", "and c.notificationUnit.adminUnit.code like :code");
            query = em.createQuery(queryStr);
            query.setParameter("code", adminUnit.getCode() + "%");
        } else if (workspace != null) {
            // add workspace restriction
            queryStr = queryStr.replace("%restriction%", "and c.patient.workspace.id = :wsId");
            query = em.createQuery(queryStr);
            query.setParameter("wsId", workspace.getId());
        } else {
            throw new RuntimeException("TbFormDbService: Tbunit, adminunit or workspace must be set.");
        }

        query.setParameter("iniDate", selectedQuarter.getIniDate());
        query.setParameter("endDate", selectedQuarter.getEndDate());

        return query.getResultList();
    }
}
